require( "scripts/style.lua" );
require( "scripts/transitions.lua" );

kCheatFail      = 0;
kCheatPass      = 1;
kCheatMaster    = 2;
kCheatMoney     = 3;
kCheatGoto      = 4;
kCheatHighest   = 5;

function DoCheat(type, param)
    if(gDialogTable.context == "game") then
        return DoCheatGame(type, param);
    elseif(gDialogTable.context == "map") then
        return DoCheatMap(type, param);
    end
end

CheatSmallFont = { edwardian_medium, 18, WhiteColor };
CheatButtonStyle = {
    font = CheatSmallFont,
    flags = kHAlignCenter + kVAlignCenter,
    graphics = App_StandardButtonGraphics,
};
MakeDialog{
    name = "cheats_dialog",
    Bitmap{
        checkstyle = CheatCheckStyle,
        name = "cheats_window",
        x = 0, y = 0, w = 800, h = 600,
        alpha = true,
        KSplit9Image{
            x = 5, y = 5, w = 270, h = 370,
            x1		= 40,
			y1		= 40,
			x2		= 40,
			y2		= 40,
            image = "ui/backgrounds/split9_dialog_small",
            
            Text{
                x = 0, y = 5, w = 268, h = 30,
                font = {edwardian_medium, 30, WhiteColor},
                flags = kHAlignCenter + kVAlignCenter,
                label = "#CHEATS",
            },
            Text{
                name = "txt_msg",
                x = 0, y = 265, w = kMax, h = 40,
                font = { edwardian_medium, 15, WhiteColor },
                flags = kHAlignCenter + kVAlignCenter,
            },
            -------------------------------------------------- Pass, Fail, Master Cheats
            SetStyle(CheatButtonStyle);
            Button{
                name = "btn_fail",
                x = 15, y = 31, w = 115, h = 32,
                label = "#Fail Lvl",
                command = 
                    function()
                        SetLabel("txt_msg", DoCheat(kCheatFail, ""));
                        if(IsGameLoaded()) then
                            CloseWindow();
                        end
                    end
            },
            Button{
                name = "btn_pass",
                x = 15, y = 71, w = 115, h = 32,
                label = "#Pass Lvl",
                command = 
                    function()
                        SetLabel("txt_msg", DoCheat(kCheatPass, ""));
                        if(IsGameLoaded()) then
                            CloseWindow();
                        end
                    end
            },
            Button{
                name = "btn_master",
                x = 136, y = 31, w = 115, h = 32,
                label = "#Master Lvl",
                command = 
                    function()
                        SetLabel("txt_msg", DoCheat(kCheatMaster, ""));
                        if(IsGameLoaded()) then
                            CloseWindow();
                        end
                    end
            },
            -------------------------------------------------- Text Edit
            Bitmap
		    {
			    x = kCenter, y = 110,
			    image	= "gfx/textfield",
			    TextEdit
			    {
				    x = 3, y = 5, w = kMax-3, h = kMax,
				    font = { edwardian_medium, 18, BlackColor },
				    name	= "txt_edit",
			    },
		    },
		    -------------------------------------------------- Add Money Cheat
            SetStyle(CheatButtonStyle);
            Button{
                x = 15, y = 145, w = 115, h = 32,
                label = "#Add Money",
                command = 
                    function()
                        SetLabel("txt_msg", DoCheat(kCheatMoney, GetLabel("txt_edit")));
                    end
            },
            -------------------------------------------------- Goto Level Cheat
            Button{
                x = 136, y = 145, w = 115, h = 32,
                label = "#Goto Level",
                command = 
                    function()
                        ret = DoCheat(kCheatGoto, GetLabel("txt_edit"));
                        SetLabel("txt_msg", ret);
                        if(ret == "") then
                            CloseWindow();
                        end
                    end
            },
            -------------------------------------------------- Set Highest Level Cheat
            Button{
                x = 40, y = 185, w = 187, h = 32,
                font = CheatSmallFont,
                flags = kHAlignCenter + kVAlignCenter,
                label = "#Set Highest Completed",
                graphics = App_LongButtonGraphics,
                command = 
                    function()
                        SetLabel("txt_msg", DoCheat(kCheatHighest, GetLabel("txt_edit")));
                    end
            },
            Button{
                x = 40, y = 225, w = 187, h = 32,
                font = CheatSmallFont,
                flags = kHAlignCenter + kVAlignCenter,
                label = "#Choose Achievements",
                graphics = App_LongButtonGraphics,
                command = 
                    function()
                        DoModal("scripts/cheats_achievements.lua");
                    end
            },
            -------------------------------------------------- Close Button
            SetStyle(CheatButtonStyle);
            Button{
                x = 136, y = 310, w = 115, h = 32,
                label = "#Close",
                command = 
                    function()
                        CloseWindow();
                        --PostMessage( CreateNamedMessage( kCrossFadeOut, "CloseWindow();" ) );
                    end
            },
        },
    },
}
SetFocus("txt_edit");
--PostMessage( CreateNamedMessage( kCrossFadeIn, "" ) );

--EnableWindow("btn_fail", IsGameLoaded());
--EnableWindow("btn_pass", IsGameLoaded());
--EnableWindow("btn_master", IsGameLoaded());